<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Notification";
    include 'partials/title-meta.php'; ?>

    <!-- Notification css (Toastr) -->
    <link href="assets/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Notification";
    include 'partials/menu.php'; ?>
        
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-xl-4 col-md-6">
                                                <div class="mb-3">
                                                    <div class="controls">
                                                        <label class="form-label">Title</label>
                                                        <input id="title" type="text" class="input-large form-control" placeholder="Enter a title ..." />
                                                        <label class="form-label mt-2">Message</label>
                                                        <textarea class="input-large form-control" id="message1" rows="3" placeholder="Enter a message ..."></textarea>
                                                    </div>
                                                </div>
                                                <div class="mt-4 mb-3">
                                                    <div class="form-check">
                                                        <input id="closeButton" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="closeButton" class="form-label">
                                                            Close Button
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="addBehaviorOnToastClick" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="addBehaviorOnToastClick" class="form-label">
                                                            Add behavior on toast click
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="debugInfo" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="debugInfo" class="form-label">
                                                            Debug
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="progressBar" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="progressBar" class="form-label">
                                                            Progress Bar
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="preventDuplicates" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="preventDuplicates" class="form-label">
                                                            Prevent Duplicates
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="addClear" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="addClear" class="form-label">
                                                            Add button to force clearing a toast, ignoring focus
                                                        </label>
                                                    </div>
    
                                                    <div class="form-check">
                                                        <input id="newestOnTop" type="checkbox" value="checked" class="form-check-input" />
                                                        <label for="newestOnTop" class="form-label">
                                                            Newest on top
                                                        </label>
                                                    </div>
    
    
                                                </div>
                                            </div>
    
                                            <div class="col-xl-2 col-md-6">
                                                <div class="mb-3" id="toastTypeGroup">
                                                        <label  class="form-label">Toast Type</label>
                                                        <div class="form-check form-check-success">
                                                            <input type="radio" name="radio" id="radio1" value="success"
                                                                    class="form-check-input" checked>
                                                            <label for="radio1" class="form-label">
                                                                Success
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check form-check-info">
                                                            <input type="radio" name="radio" id="radio2" value="info" class="form-check-input">
                                                            <label for="radio2" class="form-label">
                                                                Info
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check form-check-warning">
                                                            <input type="radio" name="radio" id="radio3" value="warning" class="form-check-input">
                                                            <label for="radio3" class="form-label">
                                                                Warning
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check form-check-danger">
                                                            <input type="radio" name="radio" id="radio4" value="error" class="form-check-input">
                                                            <label for="radio4" class="form-label">
                                                                Error
                                                            </label>
                                                        </div>
                                                    </div>
                                                <div class="mb-3" id="positionGroup">
                                                        <label  class="form-label">Position</label>
    
                                                        <div class="form-form-check">
                                                            <input type="radio" name="positions" id="radio5" value="toast-top-right" class="form-check-input" checked />
                                                            <label for="radio5" class="form-label">
                                                                Top Right
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio6" value="toast-bottom-right" class="form-check-input" />
                                                            <label for="radio6" class="form-label">
                                                                Bottom Right
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio7" value="toast-bottom-left" class="form-check-input" />
                                                            <label for="radio7" class="form-label">
                                                                Bottom Left
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio8" value="toast-top-left" class="form-check-input" />
                                                            <label for="radio8" class="form-label">
                                                                Top Left
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio9" value="toast-top-full-width" class="form-check-input" />
                                                            <label for="radio9" class="form-label">
                                                                Top Full Width
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio10" value="toast-bottom-full-width" class="form-check-input" />
                                                            <label for="radio10" class="form-label">
                                                                Bottom Full Width
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio11" value="toast-top-center" class="form-check-input" />
                                                            <label for="radio11" class="form-label">
                                                                Top Center
                                                            </label>
                                                        </div>
    
                                                        <div class="form-check">
                                                            <input type="radio" name="positions" id="radio12" value="toast-bottom-center" class="form-check-input" />
                                                            <label for="radio12" class="form-label">
                                                                Bottom Center
                                                            </label>
                                                        </div>
                                                    </div>
                                            </div>
    
                                            <div class="col-xl-3 col-md-6">
                                                <div class="mb-3">
                                                        <label for="showEasing" class="form-label">Show Easing</label>
                                                        <input id="showEasing" class="form-control" type="text" placeholder="swing, linear" class="input-mini form-control" value="swing" />
    
                                                        <label for="hideEasing" class="mt-2 form-label">Hide Easing</label>
                                                        <input id="hideEasing" class="form-control" type="text" placeholder="swing, linear" class="input-mini form-control" value="linear" />
    
                                                        <label for="showMethod" class="mt-2 form-label">Show Method</label>
                                                        <input id="showMethod" class="form-control" type="text" placeholder="show, fadeIn, slideDown" class="input-mini form-control" value="fadeIn" />
    
                                                        <label for="hideMethod" class="mt-2 form-label">Hide Method</label>
                                                        <input id="hideMethod" class="form-control" type="text" placeholder="hide, fadeOut, slideUp" class="input-mini form-control" value="fadeOut" />
                                                </div>
                                            </div>
    
                                            <div class="col-xl-3 col-md-6">
                                                <div class="mb-3">
                                                        <label for="showDuration" class="form-label">Show Duration</label>
                                                        <input id="showDuration" class="form-control" type="text" placeholder="ms" class="input-mini form-control" value="300" />
    
                                                        <label for="hideDuration" class="mt-2 form-label">Hide Duration</label>
                                                        <input id="hideDuration" class="form-control" type="text" placeholder="ms" class="input-mini form-control" value="1000" />
    
                                                        <label for="timeOut" class="mt-2 form-label">Time out</label>
                                                        <input id="timeOut" class="form-control" type="text" placeholder="ms" class="input-mini form-control" value="5000" />
    
                                                        <label for="extendedTimeOut" class="mt-2 form-label">Extended time out</label>
                                                        <input id="extendedTimeOut" class="form-control" type="text" placeholder="ms" class="input-mini form-control" value="1000" />
                                                </div>
                                            </div>
                                        </div><!-- end row -->
    
                                        <div class="row mt-4">
                                            <div class="col-md-12">
                                                <button type="button" class="btn btn-primary waves-effect waves-light mb-1 me-1" id="showtoast">Show Toast</button>
                                                <button type="button" class="btn btn-danger waves-effect waves-light mb-1 me-1" id="cleartoasts">Clear Toasts</button>
                                                <button type="button" class="btn btn-danger waves-effect waves-light mb-1 me-1" id="clearlasttoast">Clear Last Toast</button>
                                            </div>
                                        </div>
    
                                        <div class="row mt-2">
                                            <div class="col-md-12">
                                                <pre id='toastrOptions' class="mb-0"></pre>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->
                
                    </div> <!-- container-fluid -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- Toastr js -->
        <script src="assets/libs/toastr/build/toastr.min.js"></script>

        <script src="assets/js/pages/toastr.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>